generic
  type element is private;
package queuemod_template is
  type queue is limited private;
  procedure create (Q : in out queue);
  function empty (Q : queue) return boolean;
  procedure insert (Q : in out queue; E : element);
  procedure remove (Q : in out queue; E : out element);
private
  type queuenode;
  type queueptr is access queuenode;
  type queuenode is
    record
      contents : element;
      next : queueptr;
    end record;
  type queue is
    record
      front : queueptr;
      back : queueptr;
    end record;
end queuemod_template;
