import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.Mission;


public class MainMission extends Mission {
	
	public long missionMemorySize() {
		return 1000000;
	}
	
	protected void initialize() {
		System.out.println("Initializing main mission");
		
		/*
		 * The Shared Buffer is created in MissionMemory
		 */
		Buffer buffer = new BoundedBuffer();
	

	    /* The SCJ event consume releases Consumer. */
	    AperiodicEvent consume = new AperiodicEvent(); 	
	    
		/*
		 * Create Consumer AEH
		 * Pass a reference to the shared buffer
		 * Bind it to the consume event
		 * ManagedHandlers need to be registered
		 */
		(new Consumer(buffer, consume)).register();
		
		/*
		 * Create Producer PEH
		 * Pass a reference to the shared buffer
		 * ManagedHandlers need to be registered
		 */
		(new Producer(consume, buffer)).register();
	}

}
