import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;


public class Button extends PeriodicEventHandler{

	private AperiodicEvent event;

	public Button(AperiodicEvent e, long period_ms, long offset_ms) {		
		super(//priority
			  new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
			  //period
			  new PeriodicParameters(new RelativeTime(offset_ms, 0), new RelativeTime(period_ms, 0)),
			  //storage
			  new StorageConfigurationParameters(32768, 4096, 4096),
			  //name
			  "Button"
		      );
		this.event = e;
	}

	public void handleEvent()
	{
		this.event.fire();
	}
}
