import javax.safetycritical.AperiodicEvent;

/**
 * Controls the synchornization between several handlers
 * Each handler must trigger the barrier with its own unique id
 * When all have done so, the Aperiodic Event 
 * passed during initialization is fired
 * @author ish503
 *
 */
public class Barrier {
	private boolean[] flag;
	private AperiodicEvent e;

	/**
	 * Creates a Barrier
	 * @param size the number of handlers of interest
	 * @param launch the event to be called when the barrier is released
	 */
	public Barrier(int size, AperiodicEvent launch) 
	{
		this.flag = new boolean[size];
		this.e = launch;
	}

	/**
	 * Checks if all handlers have triggered the barrier
	 * @return true if all handlers have triggered the barrier
	 */
	public synchronized boolean isOkToFire() {
		for (int i = 0; i < this.flag.length; i++)
		{
			if (this.flag[i] == false) return false; 
		}
		
		return true;
	}
	
	/**
	 * Triggers the barrier for the specified handler id
	 * @param id
	 */
	public synchronized void trigger(int id) {
		System.out.println(" ** Barrier - receive trigger for id " + id);
		this.flag[id] = true;
		
		if (isOkToFire()) 
			{
			System.out.println(" ** Barrier - triggering launch event");
				this.e.fire();
				this.reset();
			}
	}
	
	/**
	 * Checks if the handler has already triggered the barrier
	 * @param id the unique handler id
	 * @return true if the handler has already triggered the barrier
	 */
	public synchronized boolean isAlreadyTriggered(int id) {
		return this.flag[id];
	}

	/**
	 * Resets the barrier.
	 * The event to be fired during the next barrier release
	 * is not changed.
	 */
	private synchronized void reset() {
		for (int i = 0; i < this.flag.length; i++)
		{
			this.flag[i] = false; 
		}		
	}
}
