import javax.realtime.AperiodicParameters;
import javax.realtime.Clock;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;


public class Worker extends AperiodicEventHandler  {

	private PersistentSignal _signal;
	private int _iteration;

	public Worker(PersistentSignal event){
		super(//priority
				  new PriorityParameters(PriorityScheduler.instance().getMaxPriority()),
				  //release
				  new AperiodicParameters(),
				  //storage
				  new StorageConfigurationParameters(32768, 4096, 4096),
				  //event
				  event,
				  //name
				  "Logger"
			      );
		
		this._signal = event;
		this._iteration = 0;
	}

	public PersistentSignal getSignal() {  return this._signal;  }

	public void handleEvent() {
		/* do work */
		this._iteration++;
		System.out.println("@ Logger - output iteration: " + this._iteration + "  " + Clock.getRealtimeClock().getTime() + " \n");
		
		/* Work done, set signal */
		this._signal.set();		
	}

}
