import javax.realtime.AperiodicParameters;
import javax.realtime.Clock;
import javax.realtime.PriorityParameters;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageConfigurationParameters;


public class Worker extends AperiodicEventHandler  {

	private PersistentSignal _signal;
	private int _iteration;

	public Worker(){
		super(//priority
				  new PriorityParameters(PriorityScheduler.instance().getNormPriority()),
				  //release
				  new AperiodicParameters(),
				  //storage
				  new StorageConfigurationParameters(32768, 4096, 4096),
				  //size
			      32768,
				  //name
				  "Logger"
			      );
		
		this._signal = new PersistentSignal(this);
		this._iteration = 0;
	}
	
	/**
	 * Returns a reference to the signal associated with this handler
	 * @return
	 */
	public PersistentSignal getSignal() {  return this._signal;  }

	public void handleEvent() {
		/* do work */
		this._iteration++;
		System.out.println("  2 Worker - output iteration: " + this._iteration + "  ");// + Clock.getRealtimeClock().getTime());
		
		/* Work done, set signal */
		this._signal.set();
		
	}

}
