/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import jcsp.lang.Alternative;
import jcsp.lang.Guard;
import jcsp.lang.ProcessInterruptedError;

public class CSTimer
extends Guard {
    private long msecs;

    public void setAlarm(long l) {
        this.msecs = l;
    }

    public void set(long l) {
        this.msecs = l;
    }

    public long read() {
        return System.currentTimeMillis();
    }

    public void after(long l) {
        long l2 = l - System.currentTimeMillis();
        if (l2 > 0L) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from CSTimer.after (long)\n" + interruptedException.toString());
            }
        }
    }

    public void sleep(long l) {
        if (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from CSTimer.sleep (long)\n" + interruptedException.toString());
            }
        }
    }

    boolean enable(Alternative alternative) {
        alternative.setTimeout(this.msecs);
        return false;
    }

    boolean disable() {
        return this.msecs <= System.currentTimeMillis();
    }
}

