/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import jcsp.lang.CSProcess;

public class Sequence
implements CSProcess {
    private CSProcess[] processes;
    private int nProcesses = 0;

    public Sequence() {
        this(null);
    }

    public Sequence(CSProcess[] cSProcessArray) {
        if (cSProcessArray != null) {
            this.nProcesses = cSProcessArray.length;
            this.processes = new CSProcess[this.nProcesses];
            System.arraycopy(cSProcessArray, 0, this.processes, 0, this.nProcesses);
        } else {
            this.nProcesses = 0;
            this.processes = new CSProcess[0];
        }
    }

    public synchronized void addProcess(CSProcess cSProcess) {
        if (cSProcess != null) {
            int n = this.nProcesses + 1;
            if (n > this.processes.length) {
                CSProcess[] cSProcessArray = this.processes;
                this.processes = new CSProcess[2 * n];
                System.arraycopy(cSProcessArray, 0, this.processes, 0, this.nProcesses);
            }
            this.processes[this.nProcesses] = cSProcess;
            this.nProcesses = n;
        }
    }

    public synchronized void addProcess(CSProcess[] cSProcessArray) {
        if (this.processes != null) {
            int n = cSProcessArray.length;
            int n2 = this.nProcesses + n;
            if (n2 > this.processes.length) {
                CSProcess[] cSProcessArray2 = this.processes;
                this.processes = new CSProcess[2 * n2];
                System.arraycopy(cSProcessArray2, 0, this.processes, 0, this.nProcesses);
            }
            System.arraycopy(cSProcessArray, 0, this.processes, this.nProcesses, n);
            this.nProcesses = n2;
        }
    }

    public synchronized void removeProcess(CSProcess cSProcess) {
        int n = 0;
        while (n < this.nProcesses) {
            if (this.processes[n] == cSProcess) {
                if (n < this.nProcesses - 1) {
                    System.arraycopy(this.processes, n + 1, this.processes, n, this.nProcesses - (n + 1));
                }
                --this.nProcesses;
                this.processes[this.nProcesses] = null;
                return;
            }
            ++n;
        }
    }

    public synchronized void removeAllProcesses() {
        int n = 0;
        while (n < this.nProcesses) {
            this.processes[n] = null;
            ++n;
        }
        this.nProcesses = 0;
    }

    public void run() {
        int n = 0;
        while (n < this.nProcesses) {
            this.processes[n].run();
            ++n;
        }
    }
}

