/*
 * Decompiled with CFR 0.152.
 */
package jcsp.util;

import java.io.Serializable;
import jcsp.util.BufferSizeError;
import jcsp.util.ChannelDataStore;

public class Buffer
implements ChannelDataStore,
Serializable {
    private final Object[] buffer;
    private int counter = 0;
    private int firstIndex = 0;
    private int lastIndex = 0;

    public Buffer(int n) {
        if (n < 0) {
            throw new BufferSizeError("\n*** Attempt to create a buffered channel with negative capacity");
        }
        this.buffer = new Object[n + 1];
    }

    public Object get() {
        Object object = this.buffer[this.firstIndex];
        this.buffer[this.firstIndex] = null;
        this.firstIndex = (this.firstIndex + 1) % this.buffer.length;
        --this.counter;
        return object;
    }

    public void put(Object object) {
        this.buffer[this.lastIndex] = object;
        this.lastIndex = (this.lastIndex + 1) % this.buffer.length;
        ++this.counter;
    }

    public int getState() {
        if (this.counter == 0) {
            return 0;
        }
        if (this.counter == this.buffer.length) {
            return 2;
        }
        return 1;
    }

    public Object clone() {
        return new Buffer(this.buffer.length - 1);
    }
}

