/*
 * Decompiled with CFR 0.152.
 */
package jcsp.util.ints;

import java.io.Serializable;
import jcsp.util.ints.BufferIntSizeError;
import jcsp.util.ints.ChannelDataStoreInt;

public class OverFlowingBufferInt
implements ChannelDataStoreInt,
Serializable {
    private final int[] buffer;
    private int counter = 0;
    private int firstIndex = 0;
    private int lastIndex = 0;

    public OverFlowingBufferInt(int n) {
        if (n <= 0) {
            throw new BufferIntSizeError("\n*** Attempt to create an overflowing buffered channel with negative or zero capacityn");
        }
        this.buffer = new int[n];
    }

    public int get() {
        int n = this.buffer[this.firstIndex];
        this.firstIndex = (this.firstIndex + 1) % this.buffer.length;
        --this.counter;
        return n;
    }

    public void put(int n) {
        if (this.counter < this.buffer.length) {
            this.buffer[this.lastIndex] = n;
            this.lastIndex = (this.lastIndex + 1) % this.buffer.length;
            ++this.counter;
        }
    }

    public int getState() {
        if (this.counter == 0) {
            return 0;
        }
        return 1;
    }

    public Object clone() {
        return new OverFlowingBufferInt(this.buffer.length);
    }
}

