/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.oz.util;

import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.oz.ast.ClassRef;
import net.sourceforge.czt.oz.ast.ClassSig;
import net.sourceforge.czt.oz.ast.ClassType;
import net.sourceforge.czt.typecheck.oz.impl.VariableClassSig;
import net.sourceforge.czt.typecheck.oz.impl.VariableClassType;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.ZFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnificationEnv
extends net.sourceforge.czt.typecheck.z.util.UnificationEnv {
    protected boolean strong_;

    public UnificationEnv(ZFactory zFactory, boolean strong) {
        super(zFactory);
        this.strong_ = strong;
    }

    public UnificationEnv(ZFactory zFactory) {
        this(zFactory, false);
    }

    public void setStrong(boolean strong) {
        this.strong_ = strong;
    }

    public UResult strongUnify(Type2 typeA, Type2 typeB) {
        boolean previous = this.strong_;
        this.strong_ = true;
        UResult result = this.unify(typeA, typeB);
        this.strong_ = previous;
        return result;
    }

    public UResult weakUnify(Type2 typeA, Type2 typeB) {
        boolean previous = this.strong_;
        this.strong_ = false;
        UResult result = this.unify(typeA, typeB);
        this.strong_ = previous;
        return result;
    }

    @Override
    public UResult unify(Type2 typeA, Type2 typeB) {
        UResult result = FAIL;
        result = typeA instanceof VariableClassType ? this.unifyVarClassType((VariableClassType)typeA, typeB) : (typeB instanceof VariableClassType ? this.unifyVarClassType((VariableClassType)typeB, typeA) : (typeA instanceof ClassType && typeB instanceof ClassType ? this.unifyClassType((ClassType)typeA, (ClassType)typeB) : super.unify(typeA, typeB)));
        return result;
    }

    protected UResult unifyVarClassType(VariableClassType vType, Type2 type) {
        UResult result = FAIL;
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            if (vType.getValue() != vType) {
                assert (vType.getTypes().size() > 0);
                result = this.unify(vType.getValue(), (Type2)classType);
            } else if (vType.getTypes().size() == 0) {
                vType.getTypes().add(classType);
                vType.complete();
                result = SUCC;
            }
        } else if (type instanceof VariableType || type instanceof UnknownType) {
            result = super.unify(vType, type);
        }
        return result;
    }

    protected UResult unifyClassType(ClassType typeA, ClassType typeB) {
        UResult result = FAIL;
        result = this.strong_ ? this.strongUnifyClassType(typeA, typeB) : this.weakUnifyClassType(typeA, typeB);
        return result;
    }

    protected UResult weakUnifyClassType(ClassType typeA, ClassType typeB) {
        UResult result = FAIL;
        String one = typeA.toString();
        String two = typeB.toString();
        ListTerm classRefsA = typeA.getClassSig().getClasses();
        ListTerm classRefsB = typeB.getClassSig().getClasses();
        for (ClassRef classRefA : classRefsA) {
            ClassRef classRefB = this.findRef(classRefA.getRefName(), (List<ClassRef>)classRefsB);
            if (classRefB == null) continue;
            UResult unified = this.instantiations(classRefA, classRefB);
            if (SUCC.equals((Object)unified)) {
                result = SUCC;
                continue;
            }
            if (!PARTIAL.equals((Object)unified) || SUCC.equals((Object)result)) continue;
            result = PARTIAL;
        }
        return result;
    }

    protected UResult strongUnifyClassType(ClassType typeA, ClassType typeB) {
        UResult result = SUCC;
        ListTerm classRefsA = typeA.getClassSig().getClasses();
        ListTerm classRefsB = typeB.getClassSig().getClasses();
        if (classRefsA.size() != classRefsB.size()) {
            result = FAIL;
        } else {
            for (ClassRef classRefA : classRefsA) {
                ClassRef classRefB = this.findRef(classRefA.getRefName(), (List<ClassRef>)classRefsB);
                if (classRefB == null) {
                    result = FAIL;
                    break;
                }
                UResult unified = this.instantiations(classRefA, classRefB);
                if (unified == FAIL) {
                    result = FAIL;
                    break;
                }
                if (!PARTIAL.equals((Object)unified)) continue;
                result = PARTIAL;
            }
        }
        return result;
    }

    protected void unifyClassSig(ClassSig sigA, ClassSig sigB) {
        if (sigA instanceof VariableClassSig) {
            VariableClassSig vSig = (VariableClassSig)sigA;
            vSig.setValue(sigB);
        } else if (sigB instanceof VariableClassSig) {
            VariableClassSig vSig = (VariableClassSig)sigB;
            vSig.setValue(sigA);
        }
    }

    protected UResult instantiations(ClassRef classRefA, ClassRef classRefB) {
        UResult result = SUCC;
        ListTerm typesA = classRefA.getType2();
        ListTerm typesB = classRefB.getType2();
        for (int i = 0; i < typesA.size(); ++i) {
            UResult unified = this.unify((Type2)typesA.get(i), (Type2)typesB.get(i));
            if (unified == FAIL) {
                result = FAIL;
                continue;
            }
            if (unified != PARTIAL || result == FAIL) continue;
            result = PARTIAL;
        }
        return result;
    }

    protected NameNamePair findPair(RefName oldName, ClassRef classRef) {
        NameNamePair result = null;
        ListTerm pairs = classRef.getNameNamePair();
        for (NameNamePair pair : pairs) {
            if (!oldName.equals(pair.getOldName())) continue;
            result = pair;
            break;
        }
        return result;
    }

    protected ClassRef findRef(RefName refName, List<ClassRef> classRefs) {
        ClassRef result = null;
        for (ClassRef classRef : classRefs) {
            if (!refName.getWord().equals(classRef.getRefName().getWord()) || !refName.getStroke().equals(classRef.getRefName().getStroke())) continue;
            result = classRef;
        }
        return result;
    }
}

