/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import jcircus.environment.ProcChanUseEnv;
import jcircus.exceptions.ChanUseUnificationException;
import jcircus.exceptions.DifferentCardinalitiesException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.exceptions.NotYetImplementedException;

public class ChanInfoEnv {
    private TreeMap chanInfoEnv_ = new TreeMap();

    public void put(String channelName, ProcChanUseEnv procChanUseEnv) {
        this.chanInfoEnv_.put(channelName, procChanUseEnv);
    }

    public ProcChanUseEnv get(String channelName) {
        return (ProcChanUseEnv)this.chanInfoEnv_.get(channelName);
    }

    public Iterator iteratorKeys() {
        return this.chanInfoEnv_.keySet().iterator();
    }

    public Iterator iteratorValues() {
        return this.chanInfoEnv_.values().iterator();
    }

    public boolean containsKey(String channelName) {
        return this.chanInfoEnv_.containsKey(channelName);
    }

    public ChanInfoEnv merge(ChanInfoEnv other, boolean isParallel) throws MoreThanOneWriterException, ChanUseUnificationException, DifferentCardinalitiesException {
        ProcChanUseEnv otherSyncEnv;
        String channelName;
        ChanInfoEnv result = new ChanInfoEnv();
        Iterator itThis = this.iteratorKeys();
        while (itThis.hasNext()) {
            ProcChanUseEnv resultSyncEnv;
            channelName = (String)itThis.next();
            ProcChanUseEnv thisSyncEnv = this.get(channelName);
            if (other.containsKey(channelName)) {
                otherSyncEnv = other.get(channelName);
                resultSyncEnv = thisSyncEnv.merge(otherSyncEnv, isParallel);
            } else {
                resultSyncEnv = thisSyncEnv;
            }
            result.put(channelName, resultSyncEnv);
        }
        Iterator itOther = other.iteratorKeys();
        while (itOther.hasNext()) {
            channelName = (String)itOther.next();
            otherSyncEnv = other.get(channelName);
            if (this.containsKey(channelName)) continue;
            result.put(channelName, otherSyncEnv);
        }
        return result;
    }

    public ChanInfoEnv substitute(List newChannels, List oldChannels) {
        throw new NotYetImplementedException();
    }

    public boolean isMultiSync() {
        Iterator it = this.iteratorValues();
        while (it.hasNext()) {
            ProcChanUseEnv syncEnv = (ProcChanUseEnv)it.next();
            if (!syncEnv.isMultiSync()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.chanInfoEnv_.size();
    }

    public int noMultiSync() {
        int no = 0;
        Iterator it = this.iteratorValues();
        while (it.hasNext()) {
            ProcChanUseEnv syncEnv = (ProcChanUseEnv)it.next();
            if (!syncEnv.isMultiSync()) continue;
            ++no;
        }
        return no;
    }

    public ChanInfoEnv replaceId(Integer newId) {
        ChanInfoEnv r = new ChanInfoEnv();
        Integer oldId = null;
        Integer idBasicProc = null;
        Iterator it = this.iteratorKeys();
        while (it.hasNext()) {
            String chanName = (String)it.next();
            ProcChanUseEnv chanMSEnv = this.get(chanName);
            ProcChanUseEnv newChanMSEnv = chanMSEnv.replaceId(newId, oldId);
            if (idBasicProc != null && !oldId.equals(idBasicProc)) {
                throw new RuntimeException("Method replaceIds has been called for a non-basic process.");
            }
            idBasicProc = oldId;
            r.put(chanName, newChanMSEnv);
        }
        return r;
    }

    public String print(int nTabs) {
        String tabs = "";
        while (nTabs > 0) {
            tabs = tabs + "\t";
            --nTabs;
        }
        StringBuilder s = new StringBuilder();
        s.append(tabs + "MultiSync\n");
        Iterator it = this.iteratorKeys();
        while (it.hasNext()) {
            String pName = (String)it.next();
            ProcChanUseEnv syncEnv = this.get(pName);
            s.append(tabs + pName + " -> \n");
            s.append(syncEnv.print(nTabs + 1));
        }
        return s.toString();
    }
}

