/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import jcircus.environment.ChannelEnv;
import jcircus.environment.ChannelSetEnv;
import jcircus.environment.FreeTypeEnv;
import jcircus.environment.NameTypeEnv;
import jcircus.environment.ProcChanEnv;
import jcircus.environment.ScopeStack;
import jcircus.environment.TypeList;
import jcircus.exceptions.NoNameTypeAnnotationException;
import jcircus.util.CircusType;
import jcircus.util.NameType;
import jcircus.util.Util;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.util.Factory;

public class Environment {
    private ChannelEnv channelEnv_ = new ChannelEnv();
    private ChannelSetEnv channelSetEnv_ = new ChannelSetEnv();
    private NameTypeEnv currentScope_ = new NameTypeEnv();
    private ScopeStack scopeStack_ = new ScopeStack();
    private TypeList typeList_ = new TypeList();
    private FreeTypeEnv freeTypesEnv_ = new FreeTypeEnv();
    private Factory factory_ = new Factory();

    public void openScope() {
        this.scopeStack_.push(this.currentScope_);
        this.currentScope_ = new NameTypeEnv();
    }

    public void closeScope() {
        this.currentScope_ = this.scopeStack_.pop();
    }

    public CircusType declareName(DeclName name, NameType nameType, CircusType circusType) {
        return this.declareName(name, nameType, circusType, false);
    }

    public CircusType declareName(DeclName name, NameType nameType, CircusType circusType, boolean addToTypeList) {
        if (circusType.equals((Object)CircusType.createCircusInteger())) {
            circusType.setJavaCircusTypeName("CircusInteger");
        } else if (circusType.getExpression() instanceof RefExpr) {
            String javaName = ((RefExpr)circusType.getExpression()).getRefName().toString();
            circusType.setJavaCircusTypeName(javaName);
        }
        if (addToTypeList) {
            this.typeList_.addType(circusType);
        }
        Util.addNameTypeAnn((TermA)name, nameType);
        this.currentScope_.put(name, circusType);
        return circusType;
    }

    public CircusType getCircusType(String name) {
        CircusType circusType = this.currentScope_.getCircusType(name);
        if (circusType == null) {
            circusType = this.scopeStack_.getType(name);
        }
        return circusType;
    }

    public NameType getNameType(String name) {
        NameType nameType = this.currentScope_.getNameType(name);
        if (nameType == null) {
            nameType = this.scopeStack_.getNameType(name);
        }
        if (nameType == null) {
            throw new NoNameTypeAnnotationException(name);
        }
        return nameType;
    }

    public TypeList getTypeList() {
        return this.typeList_;
    }

    public boolean isGlobalConstant(DeclName name) {
        NameTypeEnv globalScope = this.scopeStack_.isEmpty() ? this.currentScope_ : this.scopeStack_.elementAt(0);
        return globalScope.containsKey(name.toString());
    }

    public NameTypeEnv localEnvironment() {
        CircusType circusType;
        DeclName name;
        Enumeration keys;
        NameTypeEnv r = new NameTypeEnv();
        for (int i = 0; i < this.scopeStack_.size(); ++i) {
            NameTypeEnv temp = this.scopeStack_.elementAt(i);
            keys = temp.keys();
            while (keys.hasMoreElements()) {
                name = (DeclName)keys.nextElement();
                NameType nameType = (NameType)((Object)name.getAnn(NameType.class));
                if (!nameType.equals((Object)NameType.StateComponent) && !nameType.equals((Object)NameType.ProcessParam) && !nameType.equals((Object)NameType.ActionParam) && !nameType.equals((Object)NameType.LocalVariable)) continue;
                circusType = temp.getCircusType(name.toString());
                r.put(name, circusType);
            }
        }
        keys = this.currentScope_.keys();
        while (keys.hasMoreElements()) {
            name = (DeclName)keys.nextElement();
            circusType = this.currentScope_.getCircusType(name.toString());
            r.put(name, circusType);
        }
        return r;
    }

    public Signature getCurrentScopeAsSig() {
        ArrayList<NameTypePair> nameTypeList = new ArrayList<NameTypePair>();
        Enumeration keys = this.currentScope_.keys();
        while (keys.hasMoreElements()) {
            DeclName declName = (DeclName)keys.nextElement();
            CircusType circusType = this.getCircusType(declName.toString());
            NameTypePair nameTypePair = this.factory_.createNameTypePair(declName, (Type)circusType);
            nameTypeList.add(nameTypePair);
        }
        Signature signature = this.factory_.createSignature(nameTypeList);
        return signature;
    }

    public void declareProcess(String procName, ProcChanEnv procChanEnv) {
        if (procChanEnv == null) {
            throw new NullPointerException();
        }
        this.channelEnv_.put(procName, procChanEnv);
    }

    public ProcChanEnv getProcessChannelEnvironment(String procName) {
        return this.channelEnv_.get(procName);
    }

    public void freeTypesEnvironmentAdd(Freetype freetype) {
        this.freeTypesEnv_.add(freetype);
    }

    public int freeTypesEnvironmentSize() {
        return this.freeTypesEnv_.size();
    }

    public Freetype freeTypesEnvironmentGet(int i) {
        return this.freeTypesEnv_.get(i);
    }

    public boolean isFreeType(String name) {
        return this.freeTypesEnv_.isFreeType(name);
    }

    public boolean isElementFreeType(DeclName name) {
        return this.freeTypesEnv_.isElementFreeType((Name)name);
    }

    public boolean isElementFreeType(String freeType, String element) {
        return this.freeTypesEnv_.isElementFreeType(freeType, element);
    }

    public String getNameFreeType(DeclName name) {
        return this.freeTypesEnv_.getNameFreeType((Name)name);
    }

    public void declareChannelSet(String chanName, HashSet chanSet) {
        this.channelSetEnv_.insert(chanName, chanSet);
    }

    public HashSet getChannelSet(String chanName) {
        return this.channelSetEnv_.get(chanName);
    }

    public void printCurrentScope() {
        System.out.println("Current scope:");
        this.currentScope_.print();
    }

    public void printScopeStack() {
        System.out.println("Scope stack:");
        this.currentScope_.print();
    }
}

