/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jcircus.environment.ChanInfoEnv;
import jcircus.environment.ChanSyncEnv;
import jcircus.environment.ChanUseEnv;
import jcircus.environment.NameTypeEnv;
import jcircus.environment.ProcChanUseEnv;
import jcircus.exceptions.ChanDefOtherChanSyncException;
import jcircus.exceptions.ChanDefOtherChanUseException;
import jcircus.exceptions.ChanSyncUnificationException;
import jcircus.exceptions.ChanUseUnificationException;
import jcircus.exceptions.ChannelNotDefinedExceptionForProcess;
import jcircus.exceptions.DifferentCardinalitiesException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.util.ChanSync;
import jcircus.util.ChanUse;
import jcircus.util.CircusType;
import jcircus.util.NameType;
import jcircus.util.Util;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.util.Factory;

public class ProcChanEnv {
    private ChanInfoEnv chanInfoEnv_;
    private ChanUseEnv chanUseEnvVis_;
    private ChanUseEnv chanUseEnvHid_;
    private ChanSyncEnv chanSyncEnv_;
    private NameTypeEnv nameTypeEnv_;
    private Factory factory_;
    private boolean isBasicProcess_;

    public ProcChanEnv() {
        this.chanInfoEnv_ = new ChanInfoEnv();
        this.chanUseEnvVis_ = new ChanUseEnv();
        this.chanUseEnvHid_ = new ChanUseEnv();
        this.chanSyncEnv_ = new ChanSyncEnv();
        this.nameTypeEnv_ = new NameTypeEnv();
        this.factory_ = new Factory();
        this.isBasicProcess_ = false;
    }

    private ProcChanEnv(ChanInfoEnv chanInfoEnv, ChanUseEnv chanUseEnvVis, ChanUseEnv chanUseEnvHid, ChanSyncEnv chanSyncEnv, NameTypeEnv nameTypeEnv) {
        this.chanInfoEnv_ = chanInfoEnv;
        this.chanUseEnvVis_ = chanUseEnvVis;
        this.chanUseEnvHid_ = chanUseEnvHid;
        this.chanSyncEnv_ = chanSyncEnv;
        this.nameTypeEnv_ = nameTypeEnv;
        this.factory_ = new Factory();
        this.isBasicProcess_ = false;
    }

    public ChanInfoEnv getChanInfoEnv() {
        return this.chanInfoEnv_;
    }

    public void setChanInfoEnv(ChanInfoEnv chanInfoEnv) {
        this.chanInfoEnv_ = chanInfoEnv;
    }

    public ChanUseEnv getChanUseEnvVis() {
        return this.chanUseEnvVis_;
    }

    public ChanUseEnv getChanUseEnvHid() {
        return this.chanUseEnvHid_;
    }

    public ChanSyncEnv getChanSyncEnv() {
        return this.chanSyncEnv_;
    }

    public NameTypeEnv getNameTypeEnv() {
        return this.nameTypeEnv_;
    }

    public void includeVisible(String channelName, ChanUse chanUse, ChanSync chanSync, CircusType circusType) throws ChanDefOtherChanUseException, ChanDefOtherChanSyncException {
        ChanSync chanSyncInEnv;
        ChanUse chanUseInEnv;
        if (this.chanUseEnvVis_.containsKey(channelName) && !(chanUseInEnv = this.chanUseEnvVis_.get(channelName)).equals((Object)chanUse)) {
            throw new ChanDefOtherChanUseException(channelName, chanUseInEnv, chanUse);
        }
        this.chanUseEnvVis_.put(channelName, chanUse);
        if (this.chanSyncEnv_.containsKey(channelName) && !(chanSyncInEnv = this.chanSyncEnv_.get(channelName)).equals((Object)chanSync)) {
            throw new ChanDefOtherChanSyncException(channelName, chanSyncInEnv, chanSync);
        }
        this.chanSyncEnv_.put(channelName.toString(), chanSync);
        DeclName name = this.factory_.createDeclName(channelName);
        Util.addNameTypeAnn((TermA)name, NameType.Channel);
        this.nameTypeEnv_.put(name, circusType);
    }

    public ProcChanEnv merge(ProcChanEnv procChanEnv, boolean isParallel) throws MoreThanOneWriterException, ChanUseUnificationException, DifferentCardinalitiesException, ChanSyncUnificationException {
        ProcChanEnv r = new ProcChanEnv();
        ChanUseEnv newChanUseEnvVis = new ChanUseEnv();
        newChanUseEnvVis = this.chanUseEnvVis_.merge(procChanEnv.getChanUseEnvVis(), isParallel);
        ChanSyncEnv newChanSyncEnv = new ChanSyncEnv();
        newChanSyncEnv = this.chanSyncEnv_.merge(procChanEnv.getChanSyncEnv());
        NameTypeEnv newTypeEnvironment = new NameTypeEnv();
        newTypeEnvironment.putAll(this.nameTypeEnv_);
        newTypeEnvironment.putAll(procChanEnv.getNameTypeEnv());
        ChanInfoEnv newChanInfoEnv = this.chanInfoEnv_.merge(procChanEnv.chanInfoEnv_, isParallel);
        r = new ProcChanEnv(newChanInfoEnv, newChanUseEnvVis, new ChanUseEnv(), newChanSyncEnv, newTypeEnvironment);
        return r;
    }

    public ProcChanEnv substitute(List newChannels, List oldChannels) {
        ChanInfoEnv newChanInfoEnv = this.chanInfoEnv_.substitute(newChannels, oldChannels);
        ChanUseEnv newChanUseEnv = this.chanUseEnvVis_.substitute(newChannels, oldChannels);
        ChanSyncEnv newChanSyncEnv = this.chanSyncEnv_.substitute(newChannels, oldChannels);
        NameTypeEnv newNameTypeEnv = this.nameTypeEnv_.substitute(newChannels, oldChannels);
        ProcChanEnv r = new ProcChanEnv(newChanInfoEnv, newChanUseEnv, new ChanUseEnv(), newChanSyncEnv, newNameTypeEnv);
        return r;
    }

    public ProcChanEnv hide(HashSet hashSet) {
        Iterator it = hashSet.iterator();
        ChanUseEnv newChanUseEnvVis = new ChanUseEnv();
        ChanUseEnv newChanUseEnvHid = new ChanUseEnv();
        Iterator iteratorVisible = this.chanUseEnvVis_.iteratorKeys();
        while (iteratorVisible.hasNext()) {
            String channelName = (String)iteratorVisible.next();
            ChanUse javaTypeChannel = this.chanUseEnvVis_.get(channelName);
            if (hashSet.contains(channelName)) {
                newChanUseEnvHid.put(channelName, javaTypeChannel);
                continue;
            }
            newChanUseEnvVis.put(channelName, javaTypeChannel);
        }
        ProcChanEnv r = new ProcChanEnv(this.chanInfoEnv_, newChanUseEnvVis, newChanUseEnvHid, this.chanSyncEnv_, this.nameTypeEnv_);
        return r;
    }

    public ChanUse getJavaChannelType(String channelName) throws ChannelNotDefinedExceptionForProcess {
        ChanUse r;
        if (this.chanUseEnvHid_.containsKey(channelName)) {
            r = this.chanUseEnvHid_.get(channelName);
        } else if (this.chanUseEnvVis_.containsKey(channelName)) {
            r = this.chanUseEnvVis_.get(channelName);
        } else {
            throw new ChannelNotDefinedExceptionForProcess(channelName);
        }
        return r;
    }

    public void transform(Integer id) {
        Iterator itVisible = this.chanUseEnvVis_.iteratorKeys();
        while (itVisible.hasNext()) {
            String channelName = (String)itVisible.next();
            ChanUse chanUse = this.chanUseEnvVis_.get(channelName);
            ProcChanUseEnv procChanUseEnv = new ProcChanUseEnv(1);
            procChanUseEnv.put(id, chanUse);
            this.chanInfoEnv_.put(channelName, procChanUseEnv);
        }
    }

    public ProcChanEnv replaceIdInChanInfoEnv(Integer newId) {
        ProcChanEnv r = new ProcChanEnv(this.chanInfoEnv_.replaceId(newId), this.chanUseEnvVis_, new ChanUseEnv(), this.chanSyncEnv_, this.nameTypeEnv_);
        return r;
    }

    public boolean isBasicProcess() {
        return this.isBasicProcess_;
    }

    public void setBasicProcess() {
        this.isBasicProcess_ = true;
    }
}

