/*
 * Decompiled with CFR 0.152.
 */
package jcircus.util;

import java.util.List;
import jcircus.exceptions.NotYetImplementedException;
import jcircus.util.MathToolkitConstants;
import jcircus.util.Util;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.impl.TermAImpl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.util.Factory;

public class CircusType
extends TermAImpl
implements Type {
    public static final String SYNC_CHANNEL = "*SYNCHRONIZATION_CHANNEL*";
    private List genericParameters;
    private Expr expr;
    private String javaCircusTypeName;
    private int id;

    public CircusType(Expr expr) {
        this.genericParameters = null;
        this.expr = expr;
    }

    public CircusType(List genericParameters, Expr expr) {
        this.genericParameters = genericParameters;
        this.expr = expr;
    }

    public Expr getExpression() {
        return this.expr;
    }

    public List getGenericParameters() {
        return this.genericParameters;
    }

    public String getJavaCircusTypeName() {
        return this.javaCircusTypeName;
    }

    public void setJavaCircusTypeName(String javaCircusTypeName) {
        this.javaCircusTypeName = javaCircusTypeName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object other) {
        boolean r = false;
        if (other instanceof CircusType) {
            Expr otherExpr = ((CircusType)((Object)other)).getExpression();
            if (this.expr instanceof RefExpr && otherExpr instanceof RefExpr) {
                RefExpr thisRefExpr = (RefExpr)this.expr;
                RefExpr otherRefExpr = (RefExpr)otherExpr;
                if (thisRefExpr.getRefName().toString().equals(otherRefExpr.getRefName().toString())) {
                    return true;
                }
            }
            if (this.expr.equals(((CircusType)((Object)other)).getExpression())) {
                if (this.genericParameters != null && ((CircusType)((Object)other)).getGenericParameters() != null) {
                    if (this.genericParameters.size() == ((CircusType)((Object)other)).getGenericParameters().size()) {
                        r = true;
                        for (int i = 0; i < this.genericParameters.size(); ++i) {
                            if (this.genericParameters.get(i).equals(((CircusType)((Object)other)).getGenericParameters().get(i))) continue;
                            r = false;
                        }
                    }
                } else {
                    r = true;
                }
            }
        }
        return r;
    }

    public boolean isGeneric() {
        boolean r = true;
        if (this.genericParameters == null || this.genericParameters.size() == 0) {
            r = false;
        }
        return r;
    }

    public boolean isSyncType() {
        boolean r = false;
        if (this.expr instanceof RefExpr && ((RefExpr)this.expr).getRefName().toString().equals(SYNC_CHANNEL)) {
            r = true;
        }
        return r;
    }

    public static CircusType createCircusInteger() {
        Factory factory = new Factory();
        return new CircusType((Expr)factory.createRefExpr(factory.createRefName(MathToolkitConstants.NAT)));
    }

    public static CircusType createSyncType() {
        return new CircusType(Util.createSyncExpression());
    }

    public Term create(Object[] args) {
        throw new NotYetImplementedException();
    }

    public Object[] getChildren() {
        throw new NotYetImplementedException();
    }
}

