/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.typecheck.circus.util.KindOfProcess;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.NameTypePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInfo {
    private DeclName processName_;
    private KindOfProcess kindOfProcess_;
    private boolean isGeneric_;
    private List<DeclName> genParams_;
    private List<NameTypePair> usedChans_;
    private List<NameTypePair> paramsOrIndexes_;
    private List<NameTypePair> localVars_;

    public ProcessInfo(DeclName procName) {
        this.processName_ = procName;
        this.kindOfProcess_ = KindOfProcess.NORMAL;
        this.isGeneric_ = false;
        this.genParams_ = null;
        this.usedChans_ = null;
        this.paramsOrIndexes_ = null;
        this.localVars_ = new ArrayList<NameTypePair>();
    }

    public ProcessInfo(DeclName procName, boolean isGeneric, List<DeclName> params) {
        this.processName_ = procName;
        this.kindOfProcess_ = KindOfProcess.NORMAL;
        this.isGeneric_ = isGeneric;
        this.genParams_ = params;
        this.usedChans_ = null;
        this.paramsOrIndexes_ = null;
        this.localVars_ = new ArrayList<NameTypePair>();
    }

    public DeclName getProcessName() {
        return this.processName_;
    }

    public void setProcessName(DeclName processName) {
        this.processName_ = processName;
    }

    public KindOfProcess getKindOfProcess() {
        return this.kindOfProcess_;
    }

    public void setKindOfProcess(KindOfProcess kind) {
        this.kindOfProcess_ = kind;
    }

    public List<DeclName> getGenParams() {
        return this.genParams_;
    }

    public void setGenParams(List<DeclName> params) {
        this.genParams_ = params;
    }

    public boolean isGeneric() {
        return this.isGeneric_;
    }

    public void setIsGeneric(boolean isGeneric) {
        this.isGeneric_ = isGeneric;
    }

    public List<NameTypePair> getUsedChans() {
        return this.usedChans_;
    }

    public void setUsedChans(List<NameTypePair> usedChans) {
        this.usedChans_ = usedChans;
    }

    public List<NameTypePair> getParamsOrIndexes() {
        return this.paramsOrIndexes_;
    }

    public void setParamsOrIndexes(List<NameTypePair> params) {
        this.paramsOrIndexes_ = params;
    }

    public List<NameTypePair> getLocalVars() {
        return this.localVars_;
    }

    public boolean isLocalVar(DeclName name) {
        boolean result = false;
        for (NameTypePair local : this.localVars_) {
            if (!local.getName().equals(name)) continue;
            result = true;
        }
        return result;
    }

    public boolean addLocalVar(NameTypePair pair) {
        boolean result = true;
        DeclName name = pair.getName();
        for (NameTypePair local : this.localVars_) {
            if (!local.getName().equals(name)) continue;
            result = false;
        }
        if (result) {
            this.localVars_.add(pair);
        }
        return result;
    }
}

