/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.typecheck.z.Checker;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.typecheck.z.impl.VariableSignature;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.util.ParameterAnn;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.typecheck.z.util.UndeclaredAnn;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.Pred2;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.QntPred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.visitor.AndPredVisitor;
import net.sourceforge.czt.z.visitor.ExprPredVisitor;
import net.sourceforge.czt.z.visitor.MemPredVisitor;
import net.sourceforge.czt.z.visitor.NegPredVisitor;
import net.sourceforge.czt.z.visitor.Pred2Visitor;
import net.sourceforge.czt.z.visitor.PredVisitor;
import net.sourceforge.czt.z.visitor.QntPredVisitor;

public class PredChecker
extends Checker
implements QntPredVisitor,
Pred2Visitor,
AndPredVisitor,
MemPredVisitor,
NegPredVisitor,
ExprPredVisitor,
PredVisitor {
    public PredChecker(TypeChecker typeChecker) {
        super(typeChecker);
    }

    public Object visitPred(Pred pred) {
        return GlobalDefs.SUCC;
    }

    public Object visitQntPred(QntPred qntPred) {
        UResult result = GlobalDefs.SUCC;
        this.typeEnv().enterScope();
        SchText schText = qntPred.getSchText();
        schText.accept((Visitor)this.exprChecker());
        Pred pred = qntPred.getPred();
        UResult unified = (UResult)((Object)pred.accept((Visitor)this.predChecker()));
        if (unified == GlobalDefs.PARTIAL) {
            result = (UResult)((Object)pred.accept((Visitor)this.predChecker()));
        }
        this.typeEnv().exitScope();
        return result;
    }

    public Object visitPred2(Pred2 pred2) {
        Pred leftPred = pred2.getLeftPred();
        UResult lSolved = (UResult)((Object)leftPred.accept((Visitor)this.predChecker()));
        Pred rightPred = pred2.getRightPred();
        UResult rSolved = (UResult)((Object)rightPred.accept((Visitor)this.predChecker()));
        UResult result = UResult.conj(lSolved, rSolved);
        return result;
    }

    public Object visitAndPred(AndPred andPred) {
        Pred leftPred = andPred.getLeftPred();
        UResult lSolved = (UResult)((Object)leftPred.accept((Visitor)this.predChecker()));
        Pred rightPred = andPred.getRightPred();
        UResult rSolved = (UResult)((Object)rightPred.accept((Visitor)this.predChecker()));
        UResult result = this.checkChainRelOp(andPred);
        UResult solved = UResult.conj(lSolved, rSolved);
        result = UResult.conj(solved, result);
        return result;
    }

    public Object visitMemPred(MemPred memPred) {
        Expr leftExpr = memPred.getLeftExpr();
        Type2 leftType = (Type2)leftExpr.accept((Visitor)this.exprChecker());
        Expr rightExpr = memPred.getRightExpr();
        Type2 rightType = (Type2)rightExpr.accept((Visitor)this.exprChecker());
        PowerType powerType = this.factory().createPowerType(leftType);
        UResult unified = this.unify((Type2)powerType, rightType);
        if (unified == GlobalDefs.FAIL) {
            Type2 rightBaseType = this.getBaseType(rightType);
            boolean mixfix = memPred.getMixfix();
            if (mixfix && rightExpr instanceof SetExpr) {
                Object[] params = new Object[]{memPred, leftType, rightBaseType};
                this.error((TermA)memPred, ErrorMessage.TYPE_MISMATCH_IN_EQUALITY, params);
            } else if (!mixfix) {
                Object[] params = new Object[]{memPred, leftType, rightType};
                this.error((TermA)memPred, ErrorMessage.TYPE_MISMATCH_IN_MEM_PRED, params);
            } else if (!GlobalDefs.instanceOf(rightType, PowerType.class) && !GlobalDefs.instanceOf(rightType, VariableType.class)) {
                Object[] params = new Object[]{rightExpr, memPred, rightType};
                this.error((TermA)memPred, ErrorMessage.NAME_NOT_REL_OP, params);
            } else if (GlobalDefs.instanceOf(rightType, PowerType.class)) {
                Type2 innerType = GlobalDefs.powerType(rightType).getType();
                if (GlobalDefs.instanceOf(innerType, ProdType.class)) {
                    assert (GlobalDefs.instanceOf(leftType, ProdType.class));
                    ProdType leftProdType = (ProdType)leftType;
                    ProdType rightProdType = (ProdType)innerType;
                    for (int i = 0; i < leftProdType.getType().size(); ++i) {
                        Type2 nextRight;
                        Type2 nextLeft = (Type2)leftProdType.getType().get(i);
                        UResult nextUnified = this.unify(nextLeft, nextRight = (Type2)rightProdType.getType().get(i));
                        if (nextUnified != GlobalDefs.FAIL) continue;
                        Object[] params = new Object[]{i + 1, memPred, nextLeft, nextRight};
                        this.error((TermA)memPred, ErrorMessage.TYPE_MISMATCH_IN_REL_OP, params);
                    }
                } else if (!GlobalDefs.instanceOf(innerType, VariableType.class)) {
                    assert (!GlobalDefs.instanceOf(leftType, ProdType.class));
                    Object[] params = new Object[]{1, memPred, leftType, innerType};
                    this.error((TermA)memPred, ErrorMessage.TYPE_MISMATCH_IN_REL_OP, params);
                }
            }
        }
        return unified;
    }

    public Object visitNegPred(NegPred negPred) {
        Pred pred = negPred.getPred();
        UResult result = (UResult)((Object)pred.accept((Visitor)this.predChecker()));
        return result;
    }

    public Object visitExprPred(ExprPred exprPred) {
        Expr expr = exprPred.getExpr();
        Type2 type = (Type2)expr.accept((Visitor)this.exprChecker());
        SchemaType vSchemaType = this.factory().createSchemaType();
        PowerType vPowerType = this.factory().createPowerType((Type2)vSchemaType);
        UResult result = this.unify((Type2)vPowerType, type);
        if (result == GlobalDefs.FAIL) {
            Object[] params = new Object[]{exprPred, type};
            this.error((TermA)exprPred, ErrorMessage.NON_SCHEXPR_IN_EXPR_PRED, params);
        } else {
            SchemaType schemaType = (SchemaType)vPowerType.getType();
            Signature signature = schemaType.getSignature();
            if (!GlobalDefs.instanceOf(signature, VariableSignature.class)) {
                ParameterAnn pAnn = (ParameterAnn)exprPred.getAnn(ParameterAnn.class);
                if (pAnn == null) {
                    pAnn = new ParameterAnn((List)GlobalDefs.listTerm());
                }
                ListTerm pairs = signature.getNameTypePair();
                for (int i = 0; i < pairs.size(); ++i) {
                    NameTypePair pair = (NameTypePair)pairs.get(i);
                    DeclName declName = pair.getName();
                    RefExpr refExpr = null;
                    List gParams = pAnn.getParameters();
                    if (gParams.size() != pairs.size()) {
                        RefName refName = this.factory().createRefName(declName);
                        refExpr = this.factory().createRefExpr(refName, GlobalDefs.list(), Boolean.FALSE);
                        LocAnn locAnn = (LocAnn)exprPred.getAnn(LocAnn.class);
                        GlobalDefs.addAnn((TermA)refName, locAnn);
                        GlobalDefs.addAnn((TermA)refName, exprPred);
                        pAnn.getParameters().add(refExpr);
                    } else {
                        for (RefExpr next : gParams) {
                            RefName refName = next.getRefName();
                            if (!declName.getWord().equals(refName.getWord()) || !declName.getStroke().equals(refName.getStroke())) continue;
                            refExpr = next;
                            break;
                        }
                    }
                    Type2 envType = (Type2)refExpr.accept((Visitor)this.exprChecker());
                    Object undecAnn = refExpr.getRefName().getAnn(UndeclaredAnn.class);
                    if (undecAnn != null) continue;
                    Type2 typeA = GlobalDefs.unwrapType((Type)envType);
                    Type2 typeB = GlobalDefs.unwrapType(pair.getType());
                    UResult unified = this.unify(typeA, typeB);
                    result = UResult.conj(result, unified);
                    if (unified != GlobalDefs.FAIL) continue;
                    Object[] params = new Object[]{declName, typeA, typeB};
                    this.error((TermA)exprPred, ErrorMessage.TYPE_MISMATCH_IN_SIGNATURE, params);
                }
                GlobalDefs.addAnn((TermA)exprPred, pAnn);
            }
        }
        return result;
    }
}

