/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.typecheck.z.impl.Factory;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.impl.VariableSignature;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.GenParamType;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnificationEnv {
    protected static final UResult SUCC = UResult.SUCC;
    protected static final UResult PARTIAL = UResult.PARTIAL;
    protected static final UResult FAIL = UResult.FAIL;
    protected Factory factory_ = null;
    protected Stack<List<NameTypePair>> unificationInfo_ = null;

    public UnificationEnv() {
        this((ZFactory)new ZFactoryImpl());
    }

    public UnificationEnv(ZFactory zFactory) {
        this.factory_ = new Factory(zFactory);
        this.unificationInfo_ = new Stack();
    }

    public void enterScope() {
        List info = this.list();
        this.unificationInfo_.push(info);
    }

    public void exitScope() {
        this.unificationInfo_.pop();
    }

    public boolean addGenName(DeclName name, Type2 type2) {
        boolean result = false;
        NameTypePair pair = this.factory_.createNameTypePair(name, (Type)type2);
        this.peek().add(pair);
        result = true;
        return result;
    }

    public List<NameTypePair> getPairs() {
        ArrayList<NameTypePair> result = new ArrayList<NameTypePair>();
        for (List list : this.unificationInfo_) {
            result.addAll(list);
        }
        return result;
    }

    public Type2 getType(DeclName declName) {
        UnknownType result = this.factory_.createUnknownType();
        for (NameTypePair pair : this.peek()) {
            if (declName != pair.getName()) continue;
            result = (Type2)pair.getType();
            break;
        }
        return result;
    }

    public static boolean containsVariable(Term term) {
        boolean result = false;
        if (term instanceof VariableType && UnificationEnv.variableType(term).getValue() == term) {
            return true;
        }
        if (term instanceof VariableSignature && UnificationEnv.variableSignature(term).getValue() == term) {
            return true;
        }
        Object[] children = term.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Term) || !UnificationEnv.containsVariable((Term)children[i])) continue;
            return true;
        }
        return false;
    }

    public UResult unify(Signature sigA, Signature sigB) {
        UResult result = this.unifySignature(sigA, sigB);
        return result;
    }

    public UResult unify(Type2 typeA, Type2 typeB) {
        UResult result = FAIL;
        if (UnificationEnv.isUnknownType((Term)typeA)) {
            result = this.unifyUnknownType(UnificationEnv.unknownType((Term)typeA), typeB);
        } else if (UnificationEnv.isUnknownType((Term)typeB)) {
            result = this.unifyUnknownType(UnificationEnv.unknownType((Term)typeB), typeA);
        } else if (UnificationEnv.isVariableType((Term)typeA)) {
            result = this.unifyVariableType(UnificationEnv.variableType((Term)typeA), typeB);
        } else if (UnificationEnv.isVariableType((Term)typeB)) {
            result = this.unifyVariableType(UnificationEnv.variableType((Term)typeB), typeA);
        } else if (UnificationEnv.isGivenType((Term)typeA) && UnificationEnv.isGivenType((Term)typeB)) {
            result = this.unifyGivenType(UnificationEnv.givenType((Term)typeA), UnificationEnv.givenType((Term)typeB));
        } else if (UnificationEnv.isPowerType((Term)typeA) && UnificationEnv.isPowerType((Term)typeB)) {
            result = this.unifyPowerType(UnificationEnv.powerType((Term)typeA), UnificationEnv.powerType((Term)typeB));
        } else if (UnificationEnv.isProdType((Term)typeA) && UnificationEnv.isProdType((Term)typeB)) {
            result = this.unifyProdType(UnificationEnv.prodType((Term)typeA), UnificationEnv.prodType((Term)typeB));
        } else if (UnificationEnv.isSchemaType((Term)typeA) && UnificationEnv.isSchemaType((Term)typeB)) {
            result = this.unifySchemaType(UnificationEnv.schemaType((Term)typeA), UnificationEnv.schemaType((Term)typeB));
        } else if (UnificationEnv.isGenParamType((Term)typeA) && UnificationEnv.isGenParamType((Term)typeB)) {
            result = this.unifyGenParamType(UnificationEnv.genParamType((Term)typeA), UnificationEnv.genParamType((Term)typeB));
        }
        return result;
    }

    protected UResult unifyUnknownType(UnknownType uType, Type2 type2) {
        RefName refName = uType.getRefName();
        if (UnificationEnv.isVariableType((Term)type2) && refName != null) {
            this.unifyVariableType(UnificationEnv.variableType((Term)type2), (Type2)uType);
        } else if (UnificationEnv.isPowerType((Term)type2) && UnificationEnv.isVariableType((Term)UnificationEnv.powerType((Term)type2).getType()) && uType.getRefName() != null && !uType.getIsMem()) {
            UnknownType subType = this.factory_.createUnknownType(refName, true);
            subType.getType().addAll(uType.getType());
            this.unify(UnificationEnv.powerType((Term)type2).getType(), (Type2)subType);
        }
        UResult result = PARTIAL;
        return result;
    }

    protected UResult unifyVariableType(VariableType vType, Type2 type2) {
        UResult result = SUCC;
        if (type2 instanceof VariableType && ((VariableType)type2).getValue() == vType.getValue()) {
            if (vType.getValue() instanceof VariableType) {
                result = PARTIAL;
            }
        } else if (this.contains(type2, vType)) {
            result = FAIL;
        } else {
            if (vType.getValue() == vType) {
                vType.setValue(type2);
            }
            result = this.unify(vType.getValue(), type2);
        }
        return result;
    }

    protected UResult unifyGivenType(GivenType givenTypeA, GivenType givenTypeB) {
        UResult result = givenTypeA.equals(givenTypeB) ? SUCC : FAIL;
        return result;
    }

    protected UResult unifyPowerType(PowerType powerTypeA, PowerType powerTypeB) {
        UResult result = this.unify(powerTypeA.getType(), powerTypeB.getType());
        return result;
    }

    protected UResult unifyProdType(ProdType prodTypeA, ProdType prodTypeB) {
        UResult result = SUCC;
        ListTerm typesA = prodTypeA.getType();
        ListTerm typesB = prodTypeB.getType();
        if (typesA.size() == typesB.size()) {
            for (int i = 0; i < typesA.size(); ++i) {
                UResult unified = this.unify((Type2)typesA.get(i), (Type2)typesB.get(i));
                if (FAIL.equals((Object)unified)) {
                    result = FAIL;
                    continue;
                }
                if (!PARTIAL.equals((Object)unified) || FAIL.equals((Object)result)) continue;
                result = PARTIAL;
            }
        } else {
            result = FAIL;
        }
        return result;
    }

    protected UResult unifyGenParamType(GenParamType genParamTypeA, GenParamType genParamTypeB) {
        UResult result = genParamTypeA.equals(genParamTypeB) ? SUCC : FAIL;
        return result;
    }

    protected UResult unifySchemaType(SchemaType schemaTypeA, SchemaType schemaTypeB) {
        Signature sigA = schemaTypeA.getSignature();
        Signature sigB = schemaTypeB.getSignature();
        UResult result = this.unifySignature(sigA, sigB);
        return result;
    }

    protected UResult unifySignature(Signature sigA, Signature sigB) {
        UResult result = SUCC;
        if (UnificationEnv.isVariableSignature((Term)sigA)) {
            result = this.unifyVariableSignature((VariableSignature)sigA, sigB);
        } else if (UnificationEnv.isVariableSignature((Term)sigB)) {
            result = this.unifyVariableSignature((VariableSignature)sigB, sigA);
        } else {
            ListTerm listA = sigA.getNameTypePair();
            ListTerm listB = sigB.getNameTypePair();
            if (listA.size() == listB.size()) {
                for (NameTypePair pairA : listA) {
                    NameTypePair pairB = this.findInSignature(pairA.getName(), sigB);
                    if (pairB == null) {
                        result = FAIL;
                        continue;
                    }
                    UResult unified = this.unify(UnificationEnv.unwrapType(pairA.getType()), UnificationEnv.unwrapType(pairB.getType()));
                    if (unified == FAIL) {
                        result = FAIL;
                        continue;
                    }
                    if (unified != PARTIAL || result == FAIL) continue;
                    result = PARTIAL;
                }
            } else {
                result = FAIL;
            }
        }
        return result;
    }

    protected UResult unifyVariableSignature(VariableSignature vSig, Signature sigB) {
        UResult result = SUCC;
        if (vSig.getValue() == vSig) {
            if (vSig.getValue() != sigB) {
                vSig.setValue(sigB);
            }
            if (UnificationEnv.containsVariable((Term)sigB)) {
                result = PARTIAL;
            }
        } else {
            result = this.unifySignature(vSig.getValue(), sigB);
        }
        return result;
    }

    protected boolean contains(Type2 type2, VariableType vType) {
        boolean result = false;
        if (type2 instanceof VariableType && ((VariableType)type2).getValue() == vType.getValue()) {
            result = true;
        } else if (type2 instanceof PowerType) {
            PowerType powerType = (PowerType)type2;
            result = this.contains(powerType.getType(), vType);
        } else if (type2 instanceof ProdType) {
            ProdType prodType = (ProdType)type2;
            ListTerm types = prodType.getType();
            for (Type2 next : types) {
                if (!this.contains(next, vType)) continue;
                result = true;
                break;
            }
        } else if (type2 instanceof SchemaType) {
            SchemaType schemaType = (SchemaType)type2;
            Signature signature = schemaType.getSignature();
            result = this.contains(signature, vType);
        }
        return result;
    }

    protected boolean contains(Signature signature, VariableType vType) {
        boolean result = false;
        ListTerm pairs = signature.getNameTypePair();
        for (NameTypePair pair : pairs) {
            if (!this.contains(UnificationEnv.unwrapType(pair.getType()), vType)) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<NameTypePair> peek() {
        List<NameTypePair> result = this.list();
        if (this.unificationInfo_.size() > 0) {
            result = this.unificationInfo_.peek();
        }
        return result;
    }

    protected static Type2 unwrapType(Type type) {
        Type2 result = null;
        result = type instanceof GenericType ? (UnificationEnv.genericType((Term)type).getOptionalType() != null ? UnificationEnv.genericType((Term)type).getOptionalType() : UnificationEnv.genericType((Term)type).getType()) : (Type2)type;
        return result;
    }

    protected NameTypePair findInSignature(DeclName declName, Signature signature) {
        NameTypePair result = null;
        ListTerm pairs = signature.getNameTypePair();
        for (NameTypePair pair : pairs) {
            if (!pair.getName().equals(declName)) continue;
            result = pair;
            break;
        }
        return result;
    }

    private List list() {
        return new ArrayList();
    }

    private List list(List list) {
        List result = this.list();
        result.addAll(list);
        return result;
    }

    protected static boolean isType2(Term term) {
        return term instanceof Type2;
    }

    protected static boolean isSchemaType(Term term) {
        return term instanceof SchemaType;
    }

    protected static boolean isPowerType(Term term) {
        return term instanceof PowerType;
    }

    protected static boolean isGivenType(Term term) {
        return term instanceof GivenType;
    }

    protected static boolean isGenericType(Term term) {
        return term instanceof GenericType;
    }

    protected static boolean isGenParamType(Term term) {
        return term instanceof GenParamType;
    }

    protected static boolean isProdType(Term term) {
        return term instanceof ProdType;
    }

    protected static boolean isUnknownType(Term term) {
        return term instanceof UnknownType;
    }

    protected static boolean isVariableType(Term term) {
        return term instanceof VariableType;
    }

    protected static boolean isVariableSignature(Term term) {
        return term instanceof VariableSignature;
    }

    protected static SchemaType schemaType(Term term) {
        return (SchemaType)term;
    }

    protected static PowerType powerType(Term term) {
        return (PowerType)term;
    }

    protected static GivenType givenType(Term term) {
        return (GivenType)term;
    }

    protected static GenericType genericType(Term term) {
        return (GenericType)term;
    }

    protected static GenParamType genParamType(Term term) {
        return (GenParamType)term;
    }

    protected static ProdType prodType(Term term) {
        return (ProdType)term;
    }

    protected static UnknownType unknownType(Term term) {
        return (UnknownType)term;
    }

    protected static VariableType variableType(Term term) {
        return (VariableType)term;
    }

    protected static VariableSignature variableSignature(Term term) {
        return (VariableSignature)term;
    }

    protected void debug(Object o1, Object o2) {
        System.err.println("unify(" + o1 + ", " + o2 + ")");
    }
}

