/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.parser.util.AbstractVisitor;
import net.sourceforge.czt.parser.util.DefinitionTable;
import net.sourceforge.czt.parser.util.OpTable;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import net.sourceforge.czt.z.visitor.ZSectVisitor;

public class UnfoldVisitor
extends AbstractVisitor
implements TermVisitor,
RefExprVisitor,
ZSectVisitor {
    DefinitionTable table_;
    OpTable opTable_;
    SectionInfo sectInfo_;

    public UnfoldVisitor(SectionInfo sectInfo) {
        super(sectInfo);
    }

    public Object visitTerm(Term term) {
        return VisitorUtils.visitTerm((Visitor)this, (Term)term, (boolean)true);
    }

    public Object visitRefExpr(RefExpr refExpr) {
        DefinitionTable.Definition def = this.table_.lookup(refExpr.getRefName().toString());
        if (def != null && def.getDeclNames().size() == refExpr.getExpr().size()) {
            Expr newExpr = def.getExpr();
            if (def.getDeclNames().size() == 0) {
                return newExpr;
            }
        }
        return this.visitTerm((Term)refExpr);
    }

    public Object visitZSect(ZSect zSect) {
        String name = zSect.getName();
        this.table_ = (DefinitionTable)this.get(name, DefinitionTable.class);
        this.opTable_ = (OpTable)this.get(name, OpTable.class);
        return this.visitTerm((Term)zSect);
    }
}

