/*
 * Decompiled with CFR 0.152.
 */
package application.model;

import application.model.ModelProperty;
import application.model.Observation;
import application.view.MainViewController;
import confidenceIntervalCalculation.AlphaStartEndStep;
import confidenceIntervalCalculation.Interval;
import framework.FactFramework;
import inputOutput.FactInput;
import inputOutput.Time;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import logging.FACTLogger;
import observations.ObservationCount;
import observations.StateParameterObservation;
import observations.TransitionParameter;
import parametricModelChecking.PrismDTMCModel;
import parametricModelChecking.PrismPCTLProperty;

public class ExperimentData {
    public static MainViewController mVC;
    public Time timer;
    public Float cnfLower;
    public Float cnfUpper;
    public Float cnfStep;
    public Float graphYMax = Float.valueOf(1.0f);
    public Float graphYMin = Float.valueOf(0.0f);
    public Float graphXMin = Float.valueOf(0.9f);
    public Float graphXMax = Float.valueOf(1.0f);
    public Boolean running = false;
    public Boolean resultsUnsaved = false;
    public FACTLogger flog = new FACTLogger();
    public Float[] shareArray = new Float[10];
    public Integer shareCounter = 0;
    public ArrayList<Observation> observations = new ArrayList();
    public FactFramework fact = new FactFramework();
    private String lastError = "";
    private String modelCode = "Initialise the model in here or load one.";
    private String parsedModel = "";
    private String propCode = "";
    private String evalProp = "";
    private String evalObsFile = "";
    private Integer confidenceValue = 0;
    public XYChart.Series<Number, Number> chartSeries0 = new XYChart.Series();
    public XYChart.Series<Number, Number> chartSeries1 = new XYChart.Series();
    private ObservableList<ModelProperty> propertyData = FXCollections.observableArrayList();
    private String status = "";
    public SimpleStringProperty output = new SimpleStringProperty();
    public FactInput fInput = new FactInput();
    public static String PRISMLOCATION;

    static {
        PRISMLOCATION = "/Applications/prism4.4/bin/prism";
    }

    public String getEvalProp() {
        return this.evalProp;
    }

    public void setEvalProp(String evalProp) {
        this.evalProp = evalProp;
    }

    public String getLastError() {
        String s = this.lastError;
        this.lastError = "";
        return s;
    }

    public void setLastError(String s) {
        this.lastError = s;
    }

    public String getEvalObsFile() {
        return this.evalObsFile;
    }

    public void setEvalObsFile(String evalObsFile) {
        this.evalObsFile = evalObsFile;
    }

    public Integer getConfidenceValue() {
        return this.confidenceValue;
    }

    public void setconfidenceValue(Float l, Float u, Float s) {
        this.cnfLower = l;
        this.cnfUpper = u;
        this.cnfStep = s;
    }

    public ExperimentData(FACTLogger _flog) {
        this.flog = _flog;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public ObservableList<ModelProperty> getPropertyData() {
        return this.propertyData;
    }

    public String getStatus() {
        return this.status;
    }

    public void setModel(String text) {
        this.modelCode = text;
    }

    public void setPropCode(String text) {
        this.propCode = text;
    }

    public void loadModel(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    line = br.readLine();
                }
                this.modelCode = sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.status = "Model loading failed";
            e.printStackTrace();
        }
        this.status = "Model loaded";
    }

    public void loadProps(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                this.propertyData.clear();
                while (line != null) {
                    if (line.trim().length() > 0) {
                        ModelProperty mp = new ModelProperty(line);
                        this.propertyData.add((Object)mp);
                    }
                    line = br.readLine();
                }
                this.propCode = sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.status = "Property loading failed";
            e.printStackTrace();
        }
        this.status = "Properties loaded";
    }

    public void saveModel(File file) {
        this.saveFile(file, "Saving Model file", this.modelCode);
    }

    public void saveProps(File file) {
        this.propCode = "";
        int i = 0;
        while (i < this.propertyData.size()) {
            String s = ((ModelProperty)this.propertyData.get(i)).detailProperty().getValue();
            if (s.length() > 0) {
                this.propCode = String.valueOf(this.propCode) + s + "\n";
            }
            ++i;
        }
        this.saveFile(file, "Saving Property file", this.propCode);
    }

    private void saveFile(File file, String sMessage, String data) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(data);
            bw.close();
            this.status = String.valueOf(sMessage) + " successful.";
        }
        catch (IOException e) {
            this.status = String.valueOf(sMessage) + " failed.";
            e.printStackTrace();
        }
    }

    public void saveExperiment(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("!--**--\n");
            bw.write(String.valueOf(this.modelCode) + "\n");
            bw.write("!--**--\n");
            int i = 0;
            while (i < this.propertyData.size()) {
                String sProp = ((ModelProperty)this.propertyData.get(i)).getDetail();
                bw.write(String.valueOf(sProp) + "\n");
                ++i;
            }
            bw.write("!--**--\n");
            bw.write(String.valueOf(this.evalObsFile) + "\n");
            bw.write("!--**--\n");
            bw.write(String.valueOf(this.confidenceValue.toString()) + "\n");
            bw.close();
            this.status = "Experiment saved.";
        }
        catch (IOException e) {
            this.status = "Saving experiment failed.";
            e.printStackTrace();
        }
    }

    public void loadExperiment(File file) {
        int mode = 0;
        this.propertyData.clear();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    if (line.equals("!--**--")) {
                        if (mode == 0) {
                            sb = new StringBuilder();
                            ++mode;
                        } else if (mode == 1) {
                            this.modelCode = sb.toString();
                            sb = new StringBuilder();
                            ++mode;
                        } else if (mode == 2) {
                            this.propCode = sb.toString();
                            sb = new StringBuilder();
                            ++mode;
                        } else if (mode == 3) {
                            this.evalObsFile = sb.toString();
                            sb = new StringBuilder();
                            ++mode;
                        } else if (mode == 4) {
                            this.confidenceValue = Integer.parseInt(sb.toString());
                            sb = new StringBuilder();
                            ++mode;
                        }
                    } else {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                        if (mode == 2) {
                            ModelProperty mp = new ModelProperty(line);
                            this.propertyData.add((Object)mp);
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.status = "Experiment data loading failed";
            e.printStackTrace();
        }
        this.status = "Experiment data loaded";
    }

    public void clearChartData() {
        this.chartSeries0.getData().clear();
        this.chartSeries1.getData().clear();
        NumberAxis yAxis = (NumberAxis)ExperimentData.mVC.chtOutput.getYAxis();
        yAxis.setAutoRanging(false);
        yAxis.setUpperBound(1.0);
        yAxis.setLowerBound(0.0);
    }

    public void addChartData(double x, double y, int series) {
        if (series == 0) {
            this.chartSeries0.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
        } else {
            this.chartSeries1.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parseParams() {
        newModel = "";
        is = new ByteArrayInputStream(this.modelCode.getBytes());
        br = new BufferedReader(new InputStreamReader(is));
        this.observations.clear();
        counter = 0;
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                block9: {
                    if ((line = br.readLine()) == null) {
                        br.close();
                        return newModel;
                    }
                    testParam2 = "^\\s*param\\s+\\w+\\s+:\\s+observations\\s*=(\\s+\\d+){1,}\\s*?;\\s+component\\s*=(\\s+\\d+)\\s*?;\\s*?(\\s+cost\\s*=(\\s+[+]?\\d*\\.\\d+)(?![+0-9\\.])\\s*?;\\s*?)?";
                    if (!line.matches(testParam2)) break block9;
                    obs = new Observation();
                    spVal = line.trim().replace("=", " ").replace(";", "").split("\\s+\\s*?");
                    counter = 0;
                    var12_15 = spVal;
                    var11_14 = spVal.length;
                    var10_12 = 0;
                    ** GOTO lbl29
                }
                newModel = String.valueOf(newModel) + line + "\n";
                continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newModel;
        while (!(s = var12_15[var10_12]).matches("component")) {
            ++counter;
            ++var10_12;
lbl29:
            // 2 sources

            if (var10_12 < var11_14) continue;
        }
        if (counter < counter - 3) {
            System.err.println("Param parse error: format incorrect");
        }
        i = 1;
        while (i <= counter - 4) {
            ++i;
        }
        if (!obs.initialise(line).booleanValue()) {
            this.flog.add("Observation: Initialise failed - Syntax issue?");
            return "";
        }
        this.observations.add(obs);
        i = 0;
        while (true) {
            if (i < obs.getSize()) ** break;
            ** continue;
            newLine = "const " + obs.type + " " + obs.name + (i + 1) + ";";
            newModel = String.valueOf(newModel) + newLine + "\n";
            ++i;
        }
    }

    public void populateFACT() {
        this.parsedModel = this.parseParams();
        this.fInput.resetObservations();
        this.fInput.modelReset();
        if (this.parsedModel == "") {
            mVC.setStatus("Unable to parse Model parameters");
        }
        this.fInput.model = new PrismDTMCModel();
        this.fInput.model.setModel(this.parsedModel);
        this.fInput.property = new PrismPCTLProperty();
        this.fInput.property.setProperty(this.evalProp);
        this.flog.add("Property to evaluate: " + this.evalProp);
        double lower = (double)this.cnfLower.floatValue() / 100.0;
        double upper = (double)this.cnfUpper.floatValue() / 100.0;
        double step = (double)this.cnfStep.floatValue() / 100.0;
        this.flog.add("Confidence: " + lower + ", " + upper + ", " + step);
        this.fInput.alphaStartEndStep = new AlphaStartEndStep(lower, upper, step);
        for (Observation o : this.observations) {
            StateParameterObservation stateParameter = new StateParameterObservation();
            int i = 0;
            while (i < o.getSize()) {
                ObservationCount oCount = new ObservationCount();
                this.fInput.model.addParameter(String.valueOf(o.name) + (i + 1), new Interval(0.0, 1.0));
                oCount.transitionObservationCount = o.getParamByIndex(i);
                oCount.totalObservationCountForStateParameter = o.getTotal();
                stateParameter.addObservation(new TransitionParameter(String.valueOf(o.name) + (i + 1)), oCount);
                this.flog.add("Adding Observation: " + o.name + (i + 1) + ", " + oCount.toString());
                ++i;
            }
            this.fInput.observations.add(stateParameter);
        }
    }

    public void exportResults(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            int i = 0;
            while (i < this.fInput.ciResults.size()) {
                bw.write(this.fInput.ciResults.get((int)i).minusAlpha.alphaValue + "," + this.fInput.ciResults.get(i).getLowerBound() + ", " + this.fInput.ciResults.get(i).getUpperBound() + "\n");
                ++i;
            }
            bw.close();
            this.status = "Results saved.";
        }
        catch (IOException e) {
            this.status = "Saving results failed.";
            e.printStackTrace();
        }
    }

    public void resetchartData() {
        this.chartSeries0.getData().clear();
        this.chartSeries1.getData().clear();
    }
}

