/*
 * Decompiled with CFR 0.152.
 */
package fACT2;

import application.model.ExperimentData;
import application.model.Settings;
import confidenceIntervalCalculation.ConfidenceInterval;
import framework.FactFramework;
import inputOutput.Time;
import logging.FACTLogger;
import mathEngine.MatLabEngine;
import parametricModelChecking.OperatingSystem;
import parametricModelChecking.PrismParametricModelChecker;

public class Execute {
    public ExperimentData data = null;
    public FACTLogger flog = new FACTLogger();
    static float minCI = Float.MAX_VALUE;
    static float maxCI = -1.4E-45f;

    public Execute(ExperimentData _data, FACTLogger _flog) {
        this.data = _data;
        this.flog = _flog;
    }

    public double roundToSignificantFigures(double num, int n, boolean rdown) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = rdown ? Math.round(num * magnitude - 0.5) : Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public String run(MatLabEngine e) {
        this.flog.add("\n\n***********Run called***********\n\n");
        this.data.running = true;
        minCI = Float.MAX_VALUE;
        maxCI = Float.MIN_VALUE;
        this.data.timer = new Time();
        FactFramework fact = this.data.fact;
        Settings settings = new Settings();
        settings.read();
        if (settings.get("PRISMLocation") != null) {
            ExperimentData.PRISMLOCATION = settings.get("PRISMLocation");
        }
        fact.setPpmc(new PrismParametricModelChecker(ExperimentData.PRISMLOCATION, OperatingSystem.MAC));
        fact.setMathsEngine(e);
        this.data.populateFACT();
        this.data.fInput.ciResults.clear();
        fact.resetSimultaneousConfidenceIntervalCalculator(this.data.fInput);
        this.data.flog.add("Prism is attempting parametric model checking");
        this.data.fInput.algebraicExpression = fact.getPpmc().modelCheck(this.data.fInput.model, this.data.fInput.property, this.data.flog);
        fact.nextStepCalculateConfidenceInterval(this.data.fInput);
        ConfidenceInterval ci = fact.getLastComputedCI();
        String result = fact.getLastComputedCI().toString();
        this.data.flog.add(result);
        this.data.timer.stop();
        this.data.flog.add("Time to calculate: " + this.data.fInput.timing.toString() + "s");
        String sPoly = this.data.fInput.algebraicExpression.poly;
        if (sPoly.length() == 0) {
            this.data.flog.add("Prism failed to return a polynomial");
            this.data.running = false;
            return "";
        }
        this.data.flog.add("Model checking complete");
        this.data.flog.add("-----------------------------------------------------");
        this.data.flog.add("Polynomial sent to Matlab:");
        this.data.flog.add(sPoly);
        this.data.flog.add("Calculated in " + this.data.timer + " seconds");
        this.data.flog.add("-----------------------------------------------------");
        this.data.flog.add("Hill Climbing Max Iterations: " + this.data.fInput.config.MAX_ITERATIONS);
        return result;
    }
}

