/*
 * Decompiled with CFR 0.152.
 */
package application.model;

import application.model.ExperimentData;
import application.model.Settings;
import confidenceIntervalCalculation.ConfidenceInterval;
import framework.FactFramework;
import inputOutput.Time;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Label;
import mathEngine.MatLabEngine;
import parametricModelChecking.OperatingSystem;
import parametricModelChecking.PrismParametricModelChecker;

public class FactExecution {
    public ExperimentData data = null;
    private Service<Void> backgroundThread;
    private Service<Void> builderThread;
    public Label lbStatus;
    static float minCI = Float.MAX_VALUE;
    static float maxCI = -1.4E-45f;

    public FactExecution(ExperimentData _data) {
        this.data = _data;
    }

    public double roundToSignificantFigures(double num, int n, boolean rdown) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = rdown ? Math.round(num * magnitude - 0.5) : Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public void run() {
        this.data.flog.newLog();
        this.data.flog.add("Run called");
        this.data.running = true;
        minCI = Float.MAX_VALUE;
        maxCI = Float.MIN_VALUE;
        this.data.timer = new Time();
        final FactFramework fact = this.data.fact;
        Settings settings = new Settings();
        settings.read();
        if (settings.get("PRISMLocation") != null) {
            ExperimentData.PRISMLOCATION = settings.get("PRISMLocation");
        }
        fact.setPpmc(new PrismParametricModelChecker(ExperimentData.PRISMLOCATION, OperatingSystem.MAC));
        this.data.populateFACT();
        this.builderThread = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        (this).FactExecution.this.data.fInput.ciResults.clear();
                        fact.resetSimultaneousConfidenceIntervalCalculator((this).FactExecution.this.data.fInput);
                        (this).FactExecution.this.data.flog.add("Prism is attempting parametric model checking");
                        (this).FactExecution.this.data.fInput.algebraicExpression = fact.getPpmc().modelCheck((this).FactExecution.this.data.fInput.model, (this).FactExecution.this.data.fInput.property, (this).FactExecution.this.data.flog);
                        return null;
                    }
                };
            }
        };
        this.backgroundThread = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        fact.nextStepCalculateConfidenceInterval((this).FactExecution.this.data.fInput);
                        return null;
                    }
                };
            }
        };
        this.backgroundThread.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                ConfidenceInterval ci = fact.getLastComputedCI();
                FactExecution.this.data.flog.add(fact.getLastComputedCI().toString());
                double valueL = ci.getLowerBound();
                double valueU = ci.getUpperBound();
                double alpha = ci.minusAlpha().alphaValue;
                FactExecution.this.data.flog.add("Time to calculate: " + FactExecution.this.data.fInput.timing.toString() + "s");
                FactExecution.this.data.addChartData(alpha, valueU, 0);
                FactExecution.this.data.addChartData(alpha, valueL, 1);
                float lB = (float)Math.round(valueL * 100.0 - 0.5) / 100.0f;
                float uB = (float)Math.round(valueU * 100.0 + 0.5) / 100.0f;
                float margin = (float)FactExecution.this.roundToSignificantFigures((uB - lB) / 10.0f, 1, false);
                if (lB < minCI) {
                    minCI = lB;
                }
                if (uB > maxCI) {
                    maxCI = uB;
                }
                NumberAxis yAxis = (NumberAxis)ExperimentData.mVC.chtOutput.getYAxis();
                yAxis.setAutoRanging(false);
                double axisMax = FactExecution.this.roundToSignificantFigures(maxCI + margin, 3, false);
                double axisMin = FactExecution.this.roundToSignificantFigures(minCI - margin, 3, true);
                if (valueL >= 0.0) {
                    if (valueU < 0.05) {
                        yAxis.setUpperBound(0.05);
                    }
                    if (valueU < 0.04) {
                        yAxis.setUpperBound(0.04);
                    }
                    if (valueU < 0.03) {
                        yAxis.setUpperBound(0.03);
                    }
                    if (valueU < 0.02) {
                        yAxis.setUpperBound(0.02);
                    }
                    if (valueU < 0.01) {
                        yAxis.setUpperBound(0.01);
                    }
                    yAxis.setLowerBound(0.0);
                    yAxis.setTickUnit(0.01);
                }
                if (valueU >= 0.05) {
                    yAxis.setUpperBound(axisMax);
                    yAxis.setLowerBound(axisMin);
                    double dif = axisMax - axisMin;
                    yAxis.setTickUnit(dif / 5.0);
                }
                if (FactExecution.this.data.fInput.hasNextAlpha()) {
                    FactExecution.this.backgroundThread.restart();
                } else {
                    FactExecution.this.data.running = false;
                    FactExecution.this.data.resultsUnsaved = true;
                    FactExecution.this.data.flog.add("-----------------------------------------------------");
                    FactExecution.this.data.flog.add("Run complete");
                    FactExecution.this.data.flog.close();
                    FactExecution.this.lbStatus.setText("Evaluation Complete");
                }
            }
        });
        this.builderThread.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                FactExecution.this.data.timer.stop();
                String sPoly = FactExecution.this.data.fInput.algebraicExpression.poly;
                if (sPoly.length() == 0) {
                    FactExecution.this.data.flog.add("Prism failed to return a polynomial");
                    FactExecution.this.lbStatus.setText("Error: Model checking failed to return a polynomial");
                    FactExecution.this.data.running = false;
                    return;
                }
                FactExecution.this.lbStatus.setText("Model checking complete");
                FactExecution.this.data.flog.add("-----------------------------------------------------");
                FactExecution.this.data.flog.add("Polynomial sent to Matlab:");
                FactExecution.this.data.flog.add(sPoly);
                FactExecution.this.data.flog.add("Calculated in " + FactExecution.this.data.timer + " seconds");
                FactExecution.this.data.flog.add("-----------------------------------------------------");
                FactExecution.this.data.flog.add("Hill Climbing Max Iterations: " + FactExecution.this.data.fInput.config.MAX_ITERATIONS);
                fact.setMathsEngine(new MatLabEngine(FactExecution.this.data.flog));
                if (FactExecution.this.data.fInput.hasNextAlpha()) {
                    FactExecution.this.backgroundThread.restart();
                }
            }
        });
        this.builderThread.restart();
    }
}

