/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import matlabcontrol.JMIWrapper;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;

class LocalMatlabProxy
extends MatlabProxy {
    private volatile boolean _isConnected = true;

    LocalMatlabProxy(MatlabProxy.Identifier id) {
        super(id, true);
    }

    @Override
    public boolean isRunningInsideMatlab() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return this._isConnected;
    }

    @Override
    public boolean disconnect() {
        this._isConnected = false;
        this.notifyDisconnectionListeners();
        return true;
    }

    @Override
    public void exit() throws MatlabInvocationException {
        if (!this.isConnected()) {
            throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
        }
        JMIWrapper.exit();
    }

    @Override
    public void eval(String command) throws MatlabInvocationException {
        if (!this.isConnected()) {
            throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
        }
        JMIWrapper.eval(command);
    }

    @Override
    public Object[] returningEval(String command, int nargout) throws MatlabInvocationException {
        if (this.isConnected()) {
            return JMIWrapper.returningEval(command, nargout);
        }
        throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
    }

    @Override
    public void feval(String functionName, Object ... args) throws MatlabInvocationException {
        if (!this.isConnected()) {
            throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
        }
        JMIWrapper.feval(functionName, args);
    }

    @Override
    public Object[] returningFeval(String functionName, int nargout, Object ... args) throws MatlabInvocationException {
        if (this.isConnected()) {
            return JMIWrapper.returningFeval(functionName, nargout, args);
        }
        throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
    }

    @Override
    public void setVariable(String variableName, Object value) throws MatlabInvocationException {
        if (!this.isConnected()) {
            throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
        }
        JMIWrapper.setVariable(variableName, value);
    }

    @Override
    public Object getVariable(String variableName) throws MatlabInvocationException {
        if (this.isConnected()) {
            return JMIWrapper.getVariable(variableName);
        }
        throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
    }

    @Override
    public <T> T invokeAndWait(MatlabProxy.MatlabThreadCallable<T> callable) throws MatlabInvocationException {
        if (this.isConnected()) {
            return JMIWrapper.invokeAndWait(callable);
        }
        throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
    }
}

