/*
 * Decompiled with CFR 0.152.
 */
package testingHeuristic;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;
import testingHeuristic.Requirement;

public class Requirements {
    private ArrayList<Requirement> reqs = new ArrayList();
    private Requirement[] requirementArray;

    public Requirements(String reqsFile) throws FileNotFoundException {
        Scanner scanner = new Scanner(new File(reqsFile));
        double threshold = 0.0;
        String line = null;
        while (scanner.hasNextLine()) {
            boolean belowThreshold;
            line = scanner.nextLine();
            if (line.isEmpty()) continue;
            int pos1 = line.indexOf("<=");
            int pos2 = line.indexOf("<");
            int pos3 = line.indexOf(">=");
            int pos4 = line.indexOf(">");
            boolean bl = belowThreshold = pos1 != -1 || pos2 != -1;
            int thresholdStartIndex = pos1 != -1 ? pos1 + 2 : (pos2 != -1 ? pos2 + 1 : (pos3 != -1 ? pos3 + 2 : pos4 + 1));
            int thresholdEndIndex = line.indexOf(91, thresholdStartIndex);
            String originalReq = new String(line);
            String propertyPCTL = line;
            if (thresholdEndIndex == -1) {
                propertyPCTL = line.substring(0, thresholdStartIndex - 1);
                threshold = Double.parseDouble(line.substring(thresholdStartIndex, line.length()));
            } else {
                propertyPCTL = this.getOldFormat(propertyPCTL, thresholdStartIndex, thresholdEndIndex);
                threshold = Double.parseDouble(line.substring(thresholdStartIndex, thresholdEndIndex));
            }
            Requirement r = new Requirement(originalReq, propertyPCTL, "", threshold, belowThreshold, 0.0, 0.0);
            this.reqs.add(r);
        }
        scanner.close();
        this.requirementArray = new Requirement[this.getRequirements().size()];
        this.ArraySetter();
    }

    public String getOldFormat(String pctl) {
        pctl = pctl.trim();
        String part1 = pctl.substring(0, pctl.indexOf("["));
        String part2 = pctl.substring(pctl.indexOf("["));
        part1 = part1.replaceAll("(>|<|>=|<=)(\\d+\\.\\d+)", "=?");
        pctl = String.valueOf(part1) + part2;
        return pctl;
    }

    public String getOldFormat(String pctl, int fromIndex, int toIndex) {
        String part1 = pctl.substring(0, fromIndex - 1);
        String part2 = pctl.substring(fromIndex - 1, toIndex);
        String part3 = pctl.substring(toIndex, pctl.length());
        part2 = "=?";
        if (part3.equals("[")) {
            part2 = "";
            part3 = "";
        }
        pctl = String.valueOf(part1) + part2 + part3;
        return pctl;
    }

    public ArrayList<Requirement> getRequirements() {
        return this.reqs;
    }

    public Requirement[] getTheRequirements() {
        return this.requirementArray;
    }

    public void ArraySetter() {
        int i = 0;
        while (i < this.reqs.size()) {
            this.requirementArray[i] = this.reqs.get(i);
            ++i;
        }
    }

    public double getCIvalFromPCTL(String pctl) {
        int endIndex;
        pctl = pctl.trim();
        pctl = pctl.replaceAll("\\s+\\s*?", "");
        System.out.println(pctl);
        int startIndex = 0;
        int pos1 = pctl.indexOf(">");
        int pos2 = pctl.indexOf("<");
        int pos3 = pctl.indexOf("<=");
        int pos4 = pctl.indexOf(">=");
        if (pos1 != -1) {
            startIndex = pctl.indexOf(">");
        }
        if (pos2 != -1) {
            startIndex = pctl.indexOf("<");
        }
        if (pos3 != -1) {
            startIndex = pctl.indexOf("=");
        }
        if (pos4 != -1) {
            startIndex = pctl.indexOf("=");
        }
        if ((pctl = pctl.substring(startIndex + 1, endIndex = pctl.indexOf("["))).length() > 4 | pctl.length() < 3) {
            System.err.println("Please check the PCTL syntax, there is more than 2 digits");
            System.exit(1);
        }
        return Double.parseDouble(pctl) * 100.0;
    }
}

