/*
 * Decompiled with CFR 0.152.
 */
package confidenceIntervalCalculation;

import confidenceIntervalCalculation.Alpha;
import java.util.Iterator;

public class AlphaStartEndStep
implements Iterator<Alpha> {
    public double startAlpha;
    public double endAlpha;
    public double stepAlpha;
    private double currentAlpha;

    public AlphaStartEndStep(double start, double end, double step) {
        if (end < start) {
            throw new IllegalArgumentException("Cannot have an end point less than start point");
        }
        if (step <= 0.0) {
            throw new IllegalArgumentException("Must have a positive step value");
        }
        this.startAlpha = start;
        this.endAlpha = end;
        this.stepAlpha = step;
        this.currentAlpha = start;
    }

    @Override
    public boolean hasNext() {
        return this.currentAlpha + this.stepAlpha <= this.endAlpha + this.stepAlpha;
    }

    @Override
    public Alpha next() {
        double old = this.currentAlpha;
        this.currentAlpha += this.stepAlpha;
        return new Alpha(old);
    }

    @Override
    public void remove() {
    }

    public String toString() {
        return String.valueOf(this.startAlpha) + ":" + this.endAlpha + ":" + this.stepAlpha;
    }

    public double getCurrentAlpha() {
        return this.currentAlpha;
    }
}

