/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import matlabcontrol.Configuration;
import matlabcontrol.LocalMatlabProxyFactory;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactoryOptions;
import matlabcontrol.ProxyFactory;
import matlabcontrol.RemoteMatlabProxyFactory;

public class MatlabProxyFactory
implements ProxyFactory {
    private final ProxyFactory _delegateFactory;

    public MatlabProxyFactory() {
        this(new MatlabProxyFactoryOptions.Builder().build());
    }

    public MatlabProxyFactory(MatlabProxyFactoryOptions options) {
        this._delegateFactory = Configuration.isRunningInsideMatlab() ? new LocalMatlabProxyFactory(options) : new RemoteMatlabProxyFactory(options);
    }

    @Override
    public MatlabProxy getProxy() throws MatlabConnectionException {
        return this._delegateFactory.getProxy();
    }

    @Override
    public Request requestProxy(RequestCallback callback) throws MatlabConnectionException {
        if (callback == null) {
            throw new NullPointerException("The request callback may not be null");
        }
        return this._delegateFactory.requestProxy(callback);
    }

    public static interface Request {
        public MatlabProxy.Identifier getProxyIdentifer();

        public boolean cancel();

        public boolean isCancelled();

        public boolean isCompleted();
    }

    public static interface RequestCallback {
        public void proxyCreated(MatlabProxy var1);
    }
}

