/*
 * Decompiled with CFR 0.152.
 */
package testingHeuristic;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;
import testingHeuristic.Requirement;

public class Requirements {
    private ArrayList<Requirement> reqs = new ArrayList();
    private Requirement[] requirementArray;

    public Requirements(String reqsFile) throws FileNotFoundException {
        Scanner scanner = new Scanner(new File(reqsFile));
        double threshold = 0.0;
        String line = null;
        while (scanner.hasNextLine()) {
            boolean belowThreshold;
            line = scanner.nextLine();
            if (line.isEmpty()) continue;
            String line1 = line.substring(line.indexOf("[") + 1, line.indexOf("]"));
            String originalReq = new String(line);
            line = line.replace(line1, "");
            int pos1 = line.indexOf("<=");
            int pos2 = line.indexOf("<");
            int pos3 = line.indexOf(">=");
            int pos4 = line.indexOf(">");
            boolean bl = belowThreshold = pos1 != -1 || pos2 != -1;
            int thresholdStartIndex = pos1 != -1 ? pos1 + 2 : (pos2 != -1 ? pos2 + 1 : (pos3 != -1 ? pos3 + 2 : pos4 + 1));
            int thresholdEndIndex = line.indexOf(91, thresholdStartIndex);
            String propertyPCTL = line;
            line1 = "[" + line1 + "]";
            if (thresholdEndIndex == -1) {
                threshold = Double.parseDouble(line.substring(thresholdStartIndex, line.length()));
                propertyPCTL = this.getOldFormat(propertyPCTL, thresholdStartIndex, line1);
            } else {
                propertyPCTL = this.getOldFormat(propertyPCTL, thresholdStartIndex, line1);
                threshold = Double.parseDouble(line.substring(thresholdStartIndex, thresholdEndIndex));
            }
            Requirement r = new Requirement(originalReq, propertyPCTL, "", threshold, belowThreshold, 0.0, 0.0);
            this.reqs.add(r);
        }
        scanner.close();
        this.requirementArray = new Requirement[this.getRequirements().size()];
        this.ArraySetter();
    }

    public String getOldFormat(String pctl, int fromIndex, String between) {
        String part1 = "";
        String part2 = "";
        if (pctl.contains("=?")) {
            pctl = pctl.substring(0, pctl.indexOf("["));
            pctl = String.valueOf(pctl) + between;
        } else {
            part1 = pctl.substring(0, fromIndex - 1);
            part2 = between;
            pctl = String.valueOf(part1) + " =? " + part2;
        }
        return pctl;
    }

    public ArrayList<Requirement> getRequirements() {
        return this.reqs;
    }

    public Requirement[] getTheRequirements() {
        return this.requirementArray;
    }

    public void ArraySetter() {
        int i = 0;
        while (i < this.reqs.size()) {
            this.requirementArray[i] = this.reqs.get(i);
            ++i;
        }
    }

    public double getCIvalFromPCTL(String pctl) {
        int endIndex;
        pctl = pctl.trim();
        pctl = pctl.replaceAll("\\s+\\s*?", "");
        int startIndex = 0;
        int pos1 = pctl.indexOf(">");
        int pos2 = pctl.indexOf("<");
        int pos3 = pctl.indexOf("<=");
        int pos4 = pctl.indexOf(">=");
        if (pos1 != -1) {
            startIndex = pctl.indexOf(">");
        }
        if (pos2 != -1) {
            startIndex = pctl.indexOf("<");
        }
        if (pos3 != -1) {
            startIndex = pctl.indexOf("=");
        }
        if (pos4 != -1) {
            startIndex = pctl.indexOf("=");
        }
        if ((pctl = pctl.substring(startIndex + 1, endIndex = pctl.indexOf("["))).length() > 4 | pctl.length() < 3) {
            System.err.println("Please check the PCTL syntax, there is more than 2 digits");
            System.exit(1);
        }
        return Double.parseDouble(pctl) * 100.0;
    }
}

